-- Macro Scripts File
--
-- Macro Scripts for Trajectories maxscript commands
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

MacroScript TrajTickFramesUnselected
	ButtonText:~TRAJ_TICKFRAMESUNSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TICKFRAMESUNSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.unselTrajectoryDrawFrameTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.unselTrajectoryDrawFrameTicks = NOT maxOps.unselTrajectoryDrawFrameTicks
	)
)

MacroScript TrajDrawKeysUnselected
	ButtonText:~TRAJ_DRAWKEYSUNSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWKEYSUNSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.unselTrajectoryDrawKeys
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.unselTrajectoryDrawKeys = NOT maxOps.unselTrajectoryDrawKeys
	)
)

MacroScript TrajGradientPathSpeedColor
	ButtonText:~TRAJ_GRADIENTPATH_SPEED_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_SPEED_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #speed
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #speed
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #speed
	)
)

MacroScript TrajGradientPathWireColor
	ButtonText:~TRAJ_GRADIENTPATH_WIRECOLOR_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_WIRECOLOR_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #wireColor
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #wireColor
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #wireColor
	)
)

MacroScript TrajGradientPathUIColor
	ButtonText:~TRAJ_GRADIENTPATH_UICOLOR_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_UICOLOR_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #UIcolor
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #UIcolor
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #UIcolor
	)
)

MacroScript TrajGradientPathNone
	ButtonText:~TRAJ_GRADIENTPATH_NONE_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_NONE_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #none
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #none
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #none
	)
)

MacroScript TrajBreakSelectedTangent
	ButtonText:~TRAJ_BREAKTANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_BREAKTANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.breakSelectedKeyTangent()
	)
)

MacroScript TrajUnifySelectedTangent
	ButtonText:~TRAJ_UNIFYTANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_UNIFYTANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.UnifySelectedKeyTangent()
	)
)

MacroScript TrajSetToAutoSelectedTangent
	ButtonText:~TRAJ_SETTOAUTO_TANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_SETTOAUTO_TANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.setSelectedKeyTangentToAuto()
	)
)

MacroScript ShowFullTrajectories
	ButtonText:~TRAJ_SHOWFULLTRAJECTORY_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_SHOWFULLTRAJECTORY_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND maxOps.TrimTrajectories
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = false
	)
)

MacroScript TrimTrajectoriesWithFixedFrames
	ButtonText:~TRAJ_TRIMTRAJECTORY_FIXEDFRAMES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TRIMTRAJECTORY_FIXEDFRAMES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND (NOT maxOps.TrimTrajectories OR NOT maxOps.FixedTrimRange)
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode 
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = true
		maxOps.FixedTrimRange = true
	)
)

MacroScript TrimTrajectoriesWithMovingFrames
	ButtonText:~TRAJ_TRIMTRAJECTORY_MOVINGFRAMES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TRIMTRAJECTORY_MOVINGFRAMES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND (NOT maxOps.TrimTrajectories OR maxOps.FixedTrimRange)
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode 
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = true
		maxOps.FixedTrimRange = false
	)
)

MacroScript TrajDrawAllHandles
	ButtonText:~TRAJ_DRAWALLHANDLES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWALLHANDLES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.DrawAllHandles
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.DrawAllHandles = NOT maxOps.DrawAllHandles
	)
)

MacroScript TrajTickFramesSelected
	ButtonText:~TRAJ_TICKFRAMESSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TICKFRAMESSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.SelTrajectoryDrawFrameTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.SelTrajectoryDrawFrameTicks = NOT maxOps.SelTrajectoryDrawFrameTicks
	)
)

MacroScript TrajDrawGradientTicks
	ButtonText:~TRAJ_DRAWGRADIENTTICKS_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWGRADIENTTICKS_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.DrawGradientTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode AND maxOps.SelTrajectoryDrawFrameTicks
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.DrawGradientTicks = NOT maxOps.DrawGradientTicks
	)
)